import { ContextVariable } from './ContextVarsModel';
import { FlowType } from './QuestionnaireEnums';
import { QuestionnaireMetadata } from './QuestionnaireMetadata';
import { QuestionnaireProperties } from './QuestionnaireProperties';
import { QuestionnareTags } from './QuestionnareTags';
export interface QuestionnaireTemplate {
    isFashtagTemplate?: boolean;
    isPublic?: boolean;
    price?: number;
}
export interface Questionnare {
    id: string;
    hasBeenActivatedOnce: boolean;
    description: string;
    businessId: string;
    startNodeIds: string[];
    isValid: boolean;
    errorMessages: Record<string, string | undefined>;
    warningMessages: Record<string, string | undefined>;
    metadata: QuestionnaireMetadata;
    isSimpleQuestionnare: boolean;
    mentions: string;
    allContentVars: string[];
    variables: ContextVariable[];
    thresholdedNodes: string[];
    type: FlowType;
    isAnonymous: boolean;
    timer: number;
    tags: QuestionnareTags[];
    questionnaireProperties: QuestionnaireProperties;
    isTemplate?: boolean;
    isFashtagTemplate?: boolean;
    ownerBusinessId?: string;
    isPublic?: boolean;
    price?: number;
}
